# WP Scan Security Mejorado

**Versión:** 1.2  
**Autor:** Ariel Hernández Friz  
**Descripción:** Plugin de WordPress que escanea archivos PHP del sitio y lista aquellos que usan funciones potencialmente peligrosas, destacando su gravedad con colores, mostrando la fecha de última modificación y permitiendo exportar los resultados a CSV.



---

## Características

- Escaneo de las carpetas principales de WordPress (`wp-admin`, `wp-content`, `wp-includes`) o de todo el sitio.
- Detección de funciones potencialmente peligrosas: `eval`, `exec`, `system`, `base64_decode`.
- Resalta las funciones detectadas con colores según la gravedad.
- Muestra la fecha de última modificación de cada archivo.
- Exporta los resultados a CSV para análisis posterior.
- Interfaz amigable dentro del panel de administración de WordPress.

---

## Instalación

1. Descarga o clona este repositorio dentro de la carpeta `wp-content/plugins/` de tu instalación de WordPress.
2. Activa el plugin desde el panel de administración en **Plugins → Plugins instalados**.
3. Accede al menú **WP Scan Security** en el panel lateral de administración.
4. Selecciona la carpeta a escanear y haz clic en **Escanear**.

---

## Changelog

### 1.2
- Mejora visual: listado de archivos peligrosos ahora en tabla con columnas:
  - Nombre del archivo
  - Función potencialmente peligrosa
  - Última fecha de modificación

### 1.1
- Primera versión mejorada del plugin.  
- Escaneo de archivos PHP con funciones peligrosas.  
- Exportación a CSV.  
- Selección de carpetas específicas (`wp-admin`, `wp-content`, `wp-includes`, todo el sitio).



## Uso

1. Selecciona la carpeta a escanear:  
   - `wp-admin`  
   - `wp-content`  
   - `wp-includes`  
   - `Todo el sitio`
2. Haz clic en **Escanear**.
3. Se listarán los archivos sospechosos con:
   - Nombre y ruta del archivo.
   - Funciones detectadas con colores.
   - Fecha de última modificación.
4. Para exportar los resultados, haz clic en **Exportar CSV**.

---

## Notas

- Este plugin **no elimina malware**, solo identifica patrones de funciones potencialmente peligrosas.
- Algunas funciones detectadas pueden ser parte legítima de plugins o del núcleo de WordPress.
- Se recomienda revisar manualmente los resultados antes de tomar cualquier acción.

---

## Contribuciones

Si deseas mejorar el plugin, puedes:
- Añadir más funciones de riesgo a detectar.
- Optimizar el escaneo para reducir falsos positivos.
- Mejorar la interfaz y experiencia de usuario.

Las contribuciones son bienvenidas mediante **pull requests**.

---

## Licencia

Este proyecto está bajo la licencia GPL.



